<?php
declare(strict_types=1);

namespace NewUploader;

/**
 * مدیریت Feature Flags
 *
 * وابسته به اتصال mysqli سراسری در $connect که در config.php تنظیم شده.
 */
class Features
{
    private static ?array $cache = null;

    private static function loadAll(): void
    {
        if (self::$cache !== null) {
            return;
        }

        self::$cache = [];

        $connect = $GLOBALS['connect'] ?? null;
        if (!$connect) {
            // اگر به هر دلیل اتصال نبود، کش خالی می‌ماند
            return;
        }

        // اگر جدول features هنوز ساخته نشده باشد، این کوئری خطا می‌دهد – نادیده می‌گیریم
        $res = @mysqli_query($connect, "SELECT `key`, `value` FROM `features`");
        if ($res) {
            while ($row = mysqli_fetch_assoc($res)) {
                self::$cache[$row['key']] = $row['value'];
            }
        }

        // مقادیر پیش‌فرض
        $defaults = [
            'payments_enabled'           => 'on',
            'payments_zarinpal_enabled'  => 'on',
            'payments_zibal_enabled'     => 'on',
            'vip_enabled'                => 'on',
            'autodelete_messages_enabled'=> 'on',
        ];

        foreach ($defaults as $k => $v) {
            if (!isset(self::$cache[$k])) {
                self::$cache[$k] = $v;
            }
        }
    }

    public static function isEnabled(string $key): bool
    {
        self::loadAll();
        return (self::$cache[$key] ?? 'off') === 'on';
    }

    public static function set(string $key, string $value): void
    {
        $connect = $GLOBALS['connect'] ?? null;
        if (!$connect) {
            return;
        }

        $value = ($value === 'on') ? 'on' : 'off';
        $k = mysqli_real_escape_string($connect, $key);
        $v = mysqli_real_escape_string($connect, $value);

        $sql = "INSERT INTO `features` (`key`,`value`)
                VALUES ('{$k}','{$v}')
                ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)";

        @mysqli_query($connect, $sql);

        if (self::$cache === null) {
            self::$cache = [];
        }
        self::$cache[$key] = $value;
    }
}


