<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\Ad;

interface AdsRepositoryInterface
{
    public function findById(int $id): ?Ad;

    /**
     * @return Ad[]
     */
    public function findByOwnerAdminId(int $ownerAdminId): array;

    /**
     * @return Ad[]
     */
    public function findEnabledByOwnerAdminId(int $ownerAdminId): array;

    public function save(Ad $ad): void;

    public function delete(int $id): void;
}



