<?php

declare(strict_types=1);

use Bot\Domain\Service\AdminService;
use Bot\Domain\Service\AnalyticsService;
use Bot\Domain\Service\ForcedJoinService;
use Bot\Domain\Service\LogService;
use Bot\Domain\Service\MediaService;
use Bot\Domain\Service\PaymentService;
use Bot\Domain\Service\UserService;
use Bot\Infrastructure\Link\InMemoryLinkStore;
use Bot\Infrastructure\Repository\InMemoryAdminRepository;
use Bot\Infrastructure\Repository\InMemoryAdsRepository;
use Bot\Infrastructure\Repository\InMemoryAnalyticsRepository;
use Bot\Infrastructure\Repository\InMemoryLogRepository;
use Bot\Infrastructure\Repository\InMemoryMediaRepository;
use Bot\Infrastructure\Repository\InMemoryPaymentRepository;
use Bot\Infrastructure\Repository\InMemoryUserRepository;

// بارگذاری helper برای Database Repository ها
require_once __DIR__ . '/database-repositories.php';

// بررسی اینکه آیا دیتابیس نصب شده است
$useDatabase = isDatabaseInstalled();
$pdo = null;
$databaseConnectionError = null;

if ($useDatabase) {
    $pdo = createDatabaseConnection();
    // اگر اتصال برقرار نشد، از InMemory استفاده می‌کنیم
    if ($pdo === null) {
        $useDatabase = false;
        $databaseConnectionError = 'اتصال به دیتابیس برقرار نشد. از InMemory Repository ها استفاده می‌شود.';
    }
} else {
    $databaseConnectionError = 'فایل .database_installed یافت نشد. از InMemory Repository ها استفاده می‌شود.';
}

// ریپوزیتوری‌ها (Database یا InMemory)
if ($useDatabase && $pdo !== null) {
    // استفاده از Database Repository ها - همه چیز از دیتابیس
    $userRepo       = new \Bot\Infrastructure\Repository\Database\DatabaseUserRepository($pdo);
    $adminRepo      = new \Bot\Infrastructure\Repository\Database\DatabaseAdminRepository($pdo);
    $mediaRepo      = new \Bot\Infrastructure\Repository\Database\DatabaseMediaRepository($pdo);
    $analyticsRepo  = new \Bot\Infrastructure\Repository\Database\DatabaseAnalyticsRepository($pdo);
    $paymentRepo    = new \Bot\Infrastructure\Repository\Database\DatabasePaymentRepository($pdo);
    $adsRepo        = new \Bot\Infrastructure\Repository\Database\DatabaseAdsRepository($pdo);
    $logRepo        = new \Bot\Infrastructure\Repository\Database\DatabaseLogRepository($pdo);
    
    // لاگ برای اطمینان از استفاده از Database Repository ها
    error_log('[Services] استفاده از Database Repository ها برای همه Entity ها (User, Admin, Media, Analytics, Payment, Ads, Logs)');
} else {
    // استفاده از InMemory Repository ها
    $userRepo       = new InMemoryUserRepository();
    $adminRepo      = new InMemoryAdminRepository();
    $mediaRepo      = new InMemoryMediaRepository();
    $analyticsRepo  = new InMemoryAnalyticsRepository();
    $paymentRepo    = new InMemoryPaymentRepository();
    $adsRepo        = new InMemoryAdsRepository();
    $logRepo        = new InMemoryLogRepository();
    
    // لاگ برای اطمینان از استفاده از InMemory Repository ها
    if ($databaseConnectionError !== null) {
        error_log('[Services] ' . $databaseConnectionError);
    }
}

$linkStore      = new InMemoryLinkStore();

// سرویس‌های دامین
$userService       = new UserService($userRepo);
$adminService      = new AdminService($adminRepo);
$mediaService      = new MediaService($mediaRepo);
$analyticsService  = new AnalyticsService($analyticsRepo);
$paymentService    = new PaymentService($paymentRepo);
$adsService        = new \Bot\Domain\Service\AdsService($adsRepo);
$logService        = new LogService($logRepo);
$forcedJoinService = new ForcedJoinService();

// در دسترس قرار دادن logService به صورت global برای استفاده در logError
$GLOBALS['logService'] = $logService;

// لاگ شروع سیستم
try {
    $logService->info('سیستم ربات راه‌اندازی شد', [
        'database_enabled' => $useDatabase && $pdo !== null,
        'php_version' => PHP_VERSION,
    ]);
} catch (\Throwable $e) {
    // اگر لاگ کار نکرد، به error_log می‌نویسیم
    error_log('[Services] خطا در لاگ شروع سیستم: ' . $e->getMessage());
}

// State management برای ورودی‌های کاربر
/** @var array<int,array{action:string,step?:int,data?:array}> $userStates keyed by telegram_id */
$userStates = [];

// شمارنده‌ی ساده برای محدودیت حالت رایگان
/** @var array<int,int> $downloadCounter keyed by telegram_id */
$downloadCounter = [];

