-- Migration: افزودن جدول logs برای سیستم لاگ کامل
-- این migration جدول logs را ایجاد می‌کند
-- توجه: foreign key constraint ها به صورت اختیاری اضافه می‌شوند

-- ایجاد جدول بدون foreign key constraint
CREATE TABLE IF NOT EXISTS logs (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    level VARCHAR(16) NOT NULL, -- DEBUG|INFO|WARNING|ERROR|CRITICAL
    message TEXT NOT NULL,
    context JSON NULL, -- Additional context data
    file VARCHAR(255) NULL, -- File where log was created
    line INT NULL, -- Line number where log was created
    telegram_id BIGINT NULL, -- Related Telegram user ID
    user_id INT NULL, -- Related user ID from users table
    admin_id INT NULL, -- Related admin ID from admins table
    media_id INT NULL, -- Related media ID
    exception_type VARCHAR(255) NULL, -- Exception class name if applicable
    exception_message TEXT NULL, -- Exception message
    exception_trace TEXT NULL, -- Exception stack trace
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_level (level),
    INDEX idx_created_at (created_at),
    INDEX idx_telegram_id (telegram_id),
    INDEX idx_user_id (user_id),
    INDEX idx_level_created (level, created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- اضافه کردن foreign key constraint ها (اگر جداول مرجع وجود داشته باشند)
-- این constraint ها اختیاری هستند و اگر جداول مرجع وجود نداشته باشند، خطا نمی‌دهند

-- اضافه کردن constraint برای user_id (اگر جدول users وجود دارد)
ALTER TABLE logs 
ADD CONSTRAINT fk_logs_user 
FOREIGN KEY (user_id) REFERENCES users(id) 
ON DELETE SET NULL;

-- اضافه کردن constraint برای admin_id (اگر جدول admins وجود دارد)
ALTER TABLE logs 
ADD CONSTRAINT fk_logs_admin 
FOREIGN KEY (admin_id) REFERENCES admins(id) 
ON DELETE SET NULL;

-- اضافه کردن constraint برای media_id (اگر جدول media وجود دارد)
ALTER TABLE logs 
ADD CONSTRAINT fk_logs_media 
FOREIGN KEY (media_id) REFERENCES media(id) 
ON DELETE SET NULL;

