# راهنمای دیتابیس

## ⚠️ هشدار مهم

این نسخه از ربات از **In-Memory Repositories** استفاده می‌کند. این یعنی:

- ✅ داده‌ها فقط در حافظه RAM ذخیره می‌شوند
- ❌ با هر ریستارت ربات، **همه داده‌ها پاک می‌شوند**
- ❌ داده‌ها پایدار نیستند

## راه حل‌های پیشنهادی

### 1. استفاده از دیتابیس واقعی (توصیه می‌شود)

برای استفاده در production، باید Repository های واقعی با دیتابیس MySQL/MariaDB پیاده‌سازی شوند:

- `DatabaseUserRepository` - جایگزین `InMemoryUserRepository`
- `DatabaseAdminRepository` - جایگزین `InMemoryAdminRepository`
- `DatabaseMediaRepository` - جایگزین `InMemoryMediaRepository`
- `DatabaseAnalyticsRepository` - جایگزین `InMemoryAnalyticsRepository`
- `DatabasePaymentRepository` - جایگزین `InMemoryPaymentRepository`
- `DatabaseAdsRepository` - جایگزین `InMemoryAdsRepository`
- `DatabaseLinkStore` - جایگزین `InMemoryLinkStore`

### 2. استفاده از فایل JSON (راه حل موقت)

می‌توانید از فایل JSON برای ذخیره داده‌ها استفاده کنید. این راه حل:
- ✅ داده‌ها را در فایل ذخیره می‌کند
- ✅ با ریستارت ربات، داده‌ها حفظ می‌شوند
- ⚠️ برای production مناسب نیست (مشکلات همزمانی)

### 3. استفاده از SQLite (راه حل ساده)

SQLite یک دیتابیس فایل‌محور است که:
- ✅ نیاز به نصب سرور دیتابیس ندارد
- ✅ داده‌ها در یک فایل ذخیره می‌شوند
- ✅ برای پروژه‌های کوچک مناسب است

## نحوه پیاده‌سازی

برای پیاده‌سازی Repository های واقعی:

1. فایل `schema.sql` را در دیتابیس خود اجرا کنید
2. Repository های جدید را در `bot/src/Infrastructure/Repository/Database/` ایجاد کنید
3. در `bot/public/partials/services.php`، Repository های InMemory را با Database جایگزین کنید

## مثال

```php
// به جای:
$userRepo = new InMemoryUserRepository();

// استفاده کنید از:
$userRepo = new DatabaseUserRepository($pdo);
```

## نکات مهم

- قبل از استفاده در production، حتماً از دیتابیس واقعی استفاده کنید
- نسخه فعلی فقط برای تست و توسعه مناسب است
- داده‌های مهم را در نسخه InMemory ذخیره نکنید

