#!/bin/bash

# اسکریپت توقف ربات
# استفاده: ./stop.sh

cd "$(dirname "$0")"

PID_FILE="bot.pid"

if [ ! -f "$PID_FILE" ]; then
    echo "❌ فایل PID یافت نشد. ربات در حال اجرا نیست."
    exit 1
fi

PID=$(cat "$PID_FILE")

if ! ps -p "$PID" > /dev/null 2>&1; then
    echo "⚠️  Process با PID $PID یافت نشد."
    rm -f "$PID_FILE"
    exit 1
fi

echo "🛑 در حال توقف ربات (PID: $PID)..."

kill "$PID"

# صبر برای توقف
sleep 2

if ps -p "$PID" > /dev/null 2>&1; then
    echo "⚠️  ربات متوقف نشد. در حال force kill..."
    kill -9 "$PID"
    sleep 1
fi

if ps -p "$PID" > /dev/null 2>&1; then
    echo "❌ خطا در توقف ربات!"
    exit 1
else
    rm -f "$PID_FILE"
    echo "✅ ربات با موفقیت متوقف شد."
fi

