#!/bin/bash

# اسکریپت اجرای ربات در پس‌زمینه
# استفاده: ./start-background.sh

cd "$(dirname "$0")"

# بررسی وجود فایل .env
if [ ! -f .env ]; then
    echo "❌ فایل .env یافت نشد!"
    exit 1
fi

# بررسی وجود PHP
if ! command -v php &> /dev/null; then
    echo "❌ PHP نصب نشده است!"
    exit 1
fi

# نام فایل PID
PID_FILE="bot.pid"
LOG_FILE="bot.log"

# بررسی اینکه آیا ربات قبلاً در حال اجرا است
if [ -f "$PID_FILE" ]; then
    OLD_PID=$(cat "$PID_FILE")
    if ps -p "$OLD_PID" > /dev/null 2>&1; then
        echo "⚠️  ربات قبلاً در حال اجرا است (PID: $OLD_PID)"
        echo "برای توقف، از دستور زیر استفاده کنید:"
        echo "kill $OLD_PID"
        exit 1
    else
        # PID قدیمی وجود دارد اما process در حال اجرا نیست
        rm -f "$PID_FILE"
    fi
fi

echo "🚀 در حال اجرای ربات در پس‌زمینه..."

# اجرای ربات در پس‌زمینه و ذخیره PID
nohup php public/index.php > "$LOG_FILE" 2>&1 &
BOT_PID=$!

# ذخیره PID
echo $BOT_PID > "$PID_FILE"

echo "✅ ربات با موفقیت اجرا شد!"
echo "PID: $BOT_PID"
echo "لاگ: $LOG_FILE"
echo ""
echo "برای توقف ربات:"
echo "  kill $BOT_PID"
echo "یا:"
echo "  ./stop.sh"

