<?php

declare(strict_types=1);

namespace Bot\Infrastructure\Repository;

use Bot\Domain\Entity\User;
use Bot\Domain\Repository\UserRepositoryInterface;

/**
 * پیاده‌سازی بسیار ساده و in-memory برای توسعه و تست اولیه.
 * در محیط واقعی باید با لایه persistence (مثلاً PDO/MySQL) جایگزین شود.
 */
final class InMemoryUserRepository implements UserRepositoryInterface
{
    /** @var array<int,User> keyed by telegram_id */
    private array $usersByTelegramId = [];

    public function findByTelegramId(int $telegramId): ?User
    {
        return $this->usersByTelegramId[$telegramId] ?? null;
    }

    public function getAll(): array
    {
        return array_values($this->usersByTelegramId);
    }

    public function save(User $user): void
    {
        $this->usersByTelegramId[$user->getTelegramId()] = $user;
    }
}


