<?php

declare(strict_types=1);

namespace Bot\Infrastructure\Repository;

use Bot\Domain\Entity\Admin;
use Bot\Domain\Repository\AdminRepositoryInterface;

/**
 * پیاده‌سازی in-memory برای مدیریت ادمین‌ها.
 */
final class InMemoryAdminRepository implements AdminRepositoryInterface
{
    /** @var array<int,Admin> keyed by telegram_id */
    private array $adminsByTelegramId = [];

    public function findByTelegramId(int $telegramId): ?Admin
    {
        return $this->adminsByTelegramId[$telegramId] ?? null;
    }

    /**
     * @return Admin[]
     */
    public function getAll(): array
    {
        return array_values($this->adminsByTelegramId);
    }

    public function save(Admin $admin): void
    {
        $this->adminsByTelegramId[$admin->getTelegramId()] = $admin;
    }

    public function delete(int $telegramId): void
    {
        unset($this->adminsByTelegramId[$telegramId]);
    }
}


