<?php

declare(strict_types=1);

namespace Bot\Infrastructure\Link;

use Bot\Domain\Entity\Media;

/**
 * ذخیره‌ساز in-memory برای لینک‌های یکتای مدیا.
 * در نسخه مینیمال، داده‌ها فقط در طول اجرای پروسه نگه‌داری می‌شوند.
 */
final class InMemoryLinkStore
{
    /**
     * @var array<string,array{file_id:string,type:string,caption:?string}>
     */
    private array $links = [];

    public function createForMedia(Media $media): string
    {
        $code = bin2hex(random_bytes(4));

        $this->links[$code] = [
            'file_id' => $media->getTelegramFileId(),
            'type'    => $media->getType(),
            'caption' => $media->getCaption(),
        ];

        return $code;
    }

    /**
     * @return array{file_id:string,type:string,caption:?string}|null
     */
    public function resolve(string $code): ?array
    {
        return $this->links[$code] ?? null;
    }
}


