<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

use Bot\Domain\Entity\Admin;

interface AdminRepositoryInterface
{
    public function findByTelegramId(int $telegramId): ?Admin;

    /**
     * @return Admin[]
     */
    public function getAll(): array;

    public function save(Admin $admin): void;

    public function delete(int $telegramId): void;
}


