<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class Payment
{
    public const STATUS_PENDING = 'pending';
    public const STATUS_SUCCESS = 'success';
    public const STATUS_FAILED  = 'failed';

    public function __construct(
        private readonly int $id,
        private readonly int $userId,
        private readonly string $gateway, // telegram_stars|nextpay|zarinpal
        private readonly int $amount,
        private string $status = self::STATUS_PENDING,
        private ?string $externalId = null,
        private ?string $payload = null,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getGateway(): string
    {
        return $this->gateway;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function getPayload(): ?string
    {
        return $this->payload;
    }

    public function getExternalId(): ?string
    {
        return $this->externalId;
    }

    public function setExternalId(string $externalId): void
    {
        $this->externalId = $externalId;
    }

    public function markSuccess(string $externalId): void
    {
        $this->status     = self::STATUS_SUCCESS;
        $this->externalId = $externalId;
    }

    public function markFailed(): void
    {
        $this->status = self::STATUS_FAILED;
    }
}


