# راهنمای اجرای ربات روی سرور

این راهنما به شما کمک می‌کند که ربات Telegram را روی سرور لینوکس اجرا و مدیریت کنید.

## روش 1: استفاده از اسکریپت‌های ساده (پیشنهادی برای شروع)

### نصب و تنظیمات اولیه

1. **فایل‌های اسکریپت را قابل اجرا کنید:**
```bash
cd /path/to/bot
chmod +x start.sh start-background.sh stop.sh restart.sh status.sh
```

2. **فایل .env را ایجاد کنید:**
```bash
cp .env.example .env
nano .env
```

محتویات فایل `.env`:
```
BOT_TOKEN=your_bot_token_here
OWNER_TELEGRAM_ID=your_telegram_id
FORCED_JOIN_CHANNEL=@your_channel
NEXTPAY_API_KEY=your_nextpay_key
ZARINPAL_MERCHANT_ID=your_zarinpal_id
ZARINPAL_SANDBOX=false
PAYMENT_CALLBACK_BASE_URL=https://yourdomain.com/payment_callback.php
```

### اجرای ربات

**اجرای مستقیم (برای تست):**
```bash
./start.sh
```

**اجرای در پس‌زمینه:**
```bash
./start-background.sh
```

**بررسی وضعیت:**
```bash
./status.sh
```

**توقف ربات:**
```bash
./stop.sh
```

**ریستارت ربات:**
```bash
./restart.sh
```

### مشاهده لاگ‌ها

```bash
# مشاهده لاگ زنده
tail -f bot.log

# مشاهده آخرین 50 خط
tail -n 50 bot.log
```

---

## روش 2: استفاده از systemd (پیشنهادی برای Production)

### نصب سرویس

1. **فایل سرویس را کپی کنید:**
```bash
sudo cp bot.service /etc/systemd/system/telegram-bot.service
```

2. **مسیرها را در فایل سرویس تنظیم کنید:**
```bash
sudo nano /etc/systemd/system/telegram-bot.service
```

تغییرات لازم:
- `WorkingDirectory`: مسیر کامل به پوشه `bot`
- `ExecStart`: مسیر کامل به `php` و `public/index.php`
- `User`: کاربری که ربات را اجرا می‌کند (معمولاً `www-data` یا `nginx`)

مثال:
```ini
WorkingDirectory=/var/www/telegram-bot/bot
ExecStart=/usr/bin/php /var/www/telegram-bot/bot/public/index.php
User=www-data
```

3. **سرویس را فعال و اجرا کنید:**
```bash
# بارگذاری مجدد systemd
sudo systemctl daemon-reload

# فعال کردن سرویس (اجرای خودکار بعد از ریستارت)
sudo systemctl enable telegram-bot

# اجرای سرویس
sudo systemctl start telegram-bot
```

### مدیریت سرویس

**بررسی وضعیت:**
```bash
sudo systemctl status telegram-bot
```

**توقف:**
```bash
sudo systemctl stop telegram-bot
```

**شروع:**
```bash
sudo systemctl start telegram-bot
```

**ریستارت:**
```bash
sudo systemctl restart telegram-bot
```

**مشاهده لاگ‌ها:**
```bash
sudo journalctl -u telegram-bot -f
```

---

## روش 3: استفاده از Supervisor

### نصب Supervisor

```bash
sudo apt-get update
sudo apt-get install supervisor
```

### ایجاد فایل تنظیمات

```bash
sudo nano /etc/supervisor/conf.d/telegram-bot.conf
```

محتویات:
```ini
[program:telegram-bot]
command=/usr/bin/php /path/to/bot/public/index.php
directory=/path/to/bot
autostart=true
autorestart=true
user=www-data
redirect_stderr=true
stdout_logfile=/path/to/bot/bot.log
```

### مدیریت

```bash
# بارگذاری مجدد تنظیمات
sudo supervisorctl reread
sudo supervisorctl update

# مدیریت سرویس
sudo supervisorctl start telegram-bot
sudo supervisorctl stop telegram-bot
sudo supervisorctl restart telegram-bot
sudo supervisorctl status telegram-bot
```

---

## روش 4: استفاده از Screen یا Tmux

### با Screen

```bash
# ایجاد session جدید
screen -S telegram-bot

# اجرای ربات
cd /path/to/bot
php public/index.php

# خروج از screen (بدون توقف ربات): Ctrl+A سپس D

# بازگشت به session
screen -r telegram-bot

# مشاهده لیست sessions
screen -ls
```

### با Tmux

```bash
# ایجاد session جدید
tmux new -s telegram-bot

# اجرای ربات
cd /path/to/bot
php public/index.php

# خروج از tmux (بدون توقف ربات): Ctrl+B سپس D

# بازگشت به session
tmux attach -t telegram-bot

# مشاهده لیست sessions
tmux ls
```

---

## عیب‌یابی

### ربات اجرا نمی‌شود

1. **بررسی خطاهای PHP:**
```bash
php -l public/index.php
```

2. **بررسی فایل .env:**
```bash
cat .env
```

3. **بررسی دسترسی‌ها:**
```bash
ls -la public/index.php
```

4. **اجرای دستی برای مشاهده خطاها:**
```bash
php public/index.php
```

### ربات متوقف می‌شود

1. **بررسی لاگ‌ها:**
```bash
tail -f bot.log
```

2. **بررسی حافظه:**
```bash
free -h
```

3. **بررسی استفاده از CPU:**
```bash
top
```

### ریستارت خودکار

اگر از systemd یا supervisor استفاده می‌کنید، ربات به صورت خودکار بعد از crash ریستارت می‌شود.

---

## نکات مهم

1. **امنیت:**
   - فایل `.env` را در `.gitignore` قرار دهید
   - دسترسی فایل `.env` را محدود کنید: `chmod 600 .env`

2. **به‌روزرسانی:**
   - قبل از به‌روزرسانی، ربات را متوقف کنید
   - فایل‌های جدید را آپلود کنید
   - ربات را دوباره اجرا کنید

3. **پشتیبان‌گیری:**
   - به صورت منظم از فایل `.env` و دیتابیس (اگر دارید) پشتیبان بگیرید

---

## سوالات متداول

**Q: چطور بفهمم ربات در حال اجرا است؟**
A: از `./status.sh` یا `sudo systemctl status telegram-bot` استفاده کنید.

**Q: چطور ربات را ریستارت کنم؟**
A: از `./restart.sh` یا `sudo systemctl restart telegram-bot` استفاده کنید.

**Q: لاگ‌ها کجا هستند؟**
A: در فایل `bot.log` (اگر از اسکریپت‌ها استفاده می‌کنید) یا در journal (اگر از systemd استفاده می‌کنید).

