<?php

declare(strict_types=1);

namespace Bot\Tests\Unit;

use Bot\Domain\Service\ForcedJoinService;
use PHPUnit\Framework\TestCase;

final class ForcedJoinServiceTest extends TestCase
{
    private ForcedJoinService $forcedJoinService;

    protected function setUp(): void
    {
        $this->forcedJoinService = new ForcedJoinService();
    }

    public function testIsUserAllowedToDownloadWhenJoined(): void
    {
        $hasJoined = true;
        $result = $this->forcedJoinService->isUserAllowedToDownload($hasJoined);

        $this->assertTrue($result);
    }

    public function testIsUserAllowedToDownloadWhenNotJoined(): void
    {
        $hasJoined = false;
        $result = $this->forcedJoinService->isUserAllowedToDownload($hasJoined);

        $this->assertFalse($result);
    }
}

