<?php

declare(strict_types=1);

namespace Bot\Domain\Repository;

interface LogRepositoryInterface
{
    /**
     * ذخیره لاگ در دیتابیس
     * 
     * @param string $level سطح لاگ (DEBUG|INFO|WARNING|ERROR|CRITICAL)
     * @param string $message پیام لاگ
     * @param array<string, mixed> $context اطلاعات اضافی
     * @param ?string $file فایل ایجاد کننده لاگ
     * @param ?int $line شماره خط
     * @param ?int $telegramId شناسه تلگرام کاربر مرتبط
     * @param ?int $userId شناسه کاربر از جدول users
     * @param ?int $adminId شناسه ادمین از جدول admins
     * @param ?int $mediaId شناسه مدیا
     * @param ?\Throwable $exception استثنا در صورت وجود
     */
    public function log(
        string $level,
        string $message,
        array $context = [],
        ?string $file = null,
        ?int $line = null,
        ?int $telegramId = null,
        ?int $userId = null,
        ?int $adminId = null,
        ?int $mediaId = null,
        ?\Throwable $exception = null,
    ): void;

    /**
     * دریافت لاگ‌ها با فیلتر
     * 
     * @param ?string $level فیلتر بر اساس سطح
     * @param ?\DateTimeImmutable $startDate تاریخ شروع
     * @param ?\DateTimeImmutable $endDate تاریخ پایان
     * @param ?int $telegramId فیلتر بر اساس شناسه تلگرام
     * @param int $limit تعداد رکوردها
     * @param int $offset آفست
     * @return array<array<string, mixed>>
     */
    public function findLogs(
        ?string $level = null,
        ?\DateTimeImmutable $startDate = null,
        ?\DateTimeImmutable $endDate = null,
        ?int $telegramId = null,
        int $limit = 100,
        int $offset = 0,
    ): array;

    /**
     * شمارش لاگ‌ها با فیلتر
     */
    public function countLogs(
        ?string $level = null,
        ?\DateTimeImmutable $startDate = null,
        ?\DateTimeImmutable $endDate = null,
        ?int $telegramId = null,
    ): int;

    /**
     * حذف لاگ‌های قدیمی‌تر از تاریخ مشخص
     */
    public function deleteOldLogs(\DateTimeImmutable $beforeDate): int;
}

