<?php

declare(strict_types=1);

namespace Bot\Domain\Entity;

final class Media
{
    public function __construct(
        private readonly int $id,
        private readonly int $folderId,
        private readonly int $ownerAdminId,
        private readonly string $telegramFileId,
        private readonly string $type, // photo|video|document|...
        private readonly ?string $uuid = null,
        private ?string $thumbnailFileId = null,
        private bool $thumbnailEnabled = true,
        private ?string $caption = null,
        private ?int $autoDeleteSeconds = null,
        private bool $linkInCaptionEnabled = true,
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getFolderId(): int
    {
        return $this->folderId;
    }

    public function getOwnerAdminId(): int
    {
        return $this->ownerAdminId;
    }

    public function getTelegramFileId(): string
    {
        return $this->telegramFileId;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getThumbnailFileId(): ?string
    {
        return $this->thumbnailFileId;
    }

    public function isThumbnailEnabled(): bool
    {
        return $this->thumbnailEnabled;
    }

    public function toggleThumbnail(bool $enabled): void
    {
        $this->thumbnailEnabled = $enabled;
    }

    public function getCaption(): ?string
    {
        return $this->caption;
    }

    public function setCaption(?string $caption): void
    {
        $this->caption = $caption;
    }

    public function getAutoDeleteSeconds(): ?int
    {
        return $this->autoDeleteSeconds;
    }

    public function setAutoDeleteSeconds(?int $seconds): void
    {
        $this->autoDeleteSeconds = $seconds;
    }

    public function isLinkInCaptionEnabled(): bool
    {
        return $this->linkInCaptionEnabled;
    }

    public function toggleLinkInCaption(bool $enabled): void
    {
        $this->linkInCaptionEnabled = $enabled;
    }

    public function getUuid(): ?string
    {
        return $this->uuid;
    }
}


