#!/bin/bash
# -*- coding: utf-8 -*-

# Script to show only errors from bot log
# Usage: ./show-errors.sh

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

LOG_FILE="bot.log"

if [ ! -f "$LOG_FILE" ]; then
    echo "Log file not found: $LOG_FILE"
    exit 1
fi

echo "=== Last 50 Errors/Exceptions/Warnings ==="
echo ""
grep -iE "error|exception|fatal|warning|deprecated" "$LOG_FILE" | tail -n 50 || echo "No errors found"
echo ""
echo "=== Last 20 lines of log ==="
echo ""
tail -n 20 "$LOG_FILE"
echo ""

