#!/bin/bash
# -*- coding: utf-8 -*-

# Script to restart Telegram Bot
# Usage: ./restart.sh

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

echo "Restarting bot..."

# تابع برای kill کردن همه process های ربات
kill_all_bot_processes() {
    echo "جستجوی همه process های ربات..."
    
    # پیدا کردن همه process های مرتبط با public/index.php
    PIDS=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    
    if [ -z "$PIDS" ]; then
        echo "هیچ process رباتی یافت نشد."
        return 0
    fi
    
    echo "یافت شد: $PIDS"
    
    for PID in $PIDS; do
        echo "در حال متوقف کردن process با PID: $PID"
        kill "$PID" 2>/dev/null
    done
    
    # صبر برای توقف
    sleep 2
    
    # Force kill اگر هنوز در حال اجرا هستند
    REMAINING=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    if [ -n "$REMAINING" ]; then
        echo "Force killing باقی‌مانده process ها..."
        for PID in $REMAINING; do
            kill -9 "$PID" 2>/dev/null
        done
        sleep 1
    fi
    
    # بررسی نهایی
    FINAL_CHECK=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
    if [ -z "$FINAL_CHECK" ]; then
        echo "✅ همه process های ربات متوقف شدند."
        rm -f "bot.pid"
        return 0
    else
        echo "⚠️ برخی process ها هنوز در حال اجرا هستند: $FINAL_CHECK"
        return 1
    fi
}

# Stop bot (if running)
if [ -f "bot.pid" ]; then
    ./stop.sh
    sleep 1
fi

# Kill کردن همه process های باقی‌مانده
kill_all_bot_processes

# حذف flag restart در صورت وجود
RESTART_FLAG=".restart_in_progress"
if [ -f "$RESTART_FLAG" ]; then
    rm -f "$RESTART_FLAG"
fi

# صبر کوتاه قبل از start
sleep 1

# Start bot again
./start-background.sh

