#!/bin/bash
# -*- coding: utf-8 -*-

# Script to kill ALL bot instances
# Usage: ./killall.sh

export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8

cd "$(dirname "$0")"

echo "🔍 جستجوی همه instance های ربات..."

# پیدا کردن همه process های مرتبط با public/index.php
PIDS=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')

if [ -z "$PIDS" ]; then
    echo "✅ هیچ process رباتی یافت نشد."
    rm -f "bot.pid"
    exit 0
fi

echo "📋 یافت شد: $PIDS"
echo ""

# Kill کردن همه process ها
for PID in $PIDS; do
    echo "🛑 در حال متوقف کردن process با PID: $PID"
    kill "$PID" 2>/dev/null
done

# صبر برای توقف
echo ""
echo "⏳ در حال انتظار برای توقف..."
sleep 3

# Force kill اگر هنوز در حال اجرا هستند
REMAINING=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
if [ -n "$REMAINING" ]; then
    echo "⚠️ برخی process ها هنوز در حال اجرا هستند. Force killing..."
    for PID in $REMAINING; do
        echo "💀 Force killing PID: $PID"
        kill -9 "$PID" 2>/dev/null
    done
    sleep 1
fi

# بررسی نهایی
FINAL_CHECK=$(ps aux | grep -E "[p]hp.*public/index\.php" | awk '{print $2}')
if [ -z "$FINAL_CHECK" ]; then
    echo ""
    echo "✅ همه instance های ربات با موفقیت متوقف شدند!"
    rm -f "bot.pid"
    exit 0
else
    echo ""
    echo "❌ برخی process ها هنوز در حال اجرا هستند: $FINAL_CHECK"
    echo "💡 برای متوقف کردن دستی:"
    echo "   kill -9 $FINAL_CHECK"
    exit 1
fi

