<?php
declare(strict_types=1);

/**
 * Installation Script
 * Run this file once to set up the database
 * 
 * Usage: php install.php
 */

require_once __DIR__ . '/inc/config.php';
require_once __DIR__ . '/inc/database.php';
require_once __DIR__ . '/inc/migrations.php';
require_once __DIR__ . '/inc/logger.php';

echo "🚀 Starting installation...\n\n";

// Initialize database connection
$db = initDatabase();

if (!$db) {
    echo "❌ Failed to connect to database. Please check your database configuration in inc/config.php\n";
    exit(1);
}

echo "✅ Database connection established.\n";

// Run migrations
echo "📦 Running migrations...\n";

if (runMigrations()) {
    echo "✅ Migrations completed successfully.\n\n";
    echo "🎉 Installation completed!\n";
    echo "📝 Next steps:\n";
    echo "   1. Set up webhook for your bot\n";
    echo "   2. Start using your bot!\n";
} else {
    echo "❌ Migrations failed. Please check the logs.\n";
    exit(1);
}

