<?php
declare(strict_types=1);

/**
 * Logger Functions
 * Provides logging functionality for the bot
 */

/**
 * Log an error message
 * @param string $message
 * @return void
 */
function logError(string $message): void {
    $logFile = __DIR__ . '/../../storage/logs/bot.log';
    $logDir = dirname($logFile);
    
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[{$timestamp}] ERROR: {$message}" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

/**
 * Log an info message
 * @param string $message
 * @return void
 */
function logInfo(string $message): void {
    $logFile = __DIR__ . '/../../storage/logs/bot.log';
    $logDir = dirname($logFile);
    
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[{$timestamp}] INFO: {$message}" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

/**
 * Log a warning message
 * @param string $message
 * @return void
 */
function logWarning(string $message): void {
    $logFile = __DIR__ . '/../../storage/logs/bot.log';
    $logDir = dirname($logFile);
    
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[{$timestamp}] WARNING: {$message}" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

/**
 * Log debug information
 * @param mixed $data
 * @return void
 */
function logDebug(mixed $data): void {
    $logFile = __DIR__ . '/../../storage/logs/bot.log';
    $logDir = dirname($logFile);
    
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[{$timestamp}] DEBUG: " . print_r($data, true) . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

