<?php
declare(strict_types=1);

// M.R S.B

// Includes
include_once "inc/config.php";
include_once "inc/functions.php";
include_once "inc/keyboards.php";
include_once "inc/database.php";
include_once "inc/auth.php";
include_once "inc/validators.php";
include_once "inc/logger.php";

// Handlers
include_once "handlers/upload-handler.php";
include_once "handlers/admin-handler.php";
include_once "handlers/channel-handler.php";
include_once "handlers/point-handler.php";
include_once "handlers/referral-handler.php";
include_once "handlers/auto-delete-handler.php";
include_once "handlers/analytics-handler.php";
include_once "handlers/payment-handler.php";
include_once "handlers/broadcast-handler.php";
include_once "handlers/advertisement-handler.php";
include_once "handlers/media-handler.php";
include_once "handlers/user-handler.php";
include_once "handlers/settings-handler.php";

// Initialize database connection
initDatabase();

// Get update
$update = json_decode(file_get_contents("php://input"), true);
file_put_contents("botlog.txt", print_r($update, true));

if (!$update) {
    http_response_code(400);
    exit;
}

// Verify webhook secret token if set
if (defined('WEBHOOK_SECRET') && !empty(WEBHOOK_SECRET)) {
    $headers = getallheaders();
    $secret = $headers['X-Telegram-Bot-Api-Secret-Token'] ?? '';
    
    if ($secret !== WEBHOOK_SECRET) {
        http_response_code(403);
        exit;
    }
}

// Extract update data
$message = $update['message'] ?? null;
$callback_query = $update['callback_query'] ?? null;
$pre_checkout_query = $update['pre_checkout_query'] ?? null;
$chat_id = null;
$user_id = null;
$user_data = null;
$text = null;
$chat_type = null;

if ($message) {
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $user_data = $message['from'];
    $text = $message['text'] ?? null;
    $chat_type = $message['chat']['type'];
}

if ($callback_query) {
    $chat_id = $callback_query['message']['chat']['id'];
    $user_id = $callback_query['from']['id'];
    $user_data = $callback_query['from'];
    $text = $callback_query['data'] ?? null;
}

// Ensure user exists in database
if ($user_id) {
    ensureUserExists($user_id, $user_data);
}

// Handle pre-checkout query (payment)
if ($pre_checkout_query) {
    handleSuccessfulPayment($pre_checkout_query);
    exit;
}

// Handle callback queries
if ($callback_query) {
    $callback_data = $callback_query['data'] ?? '';
    $callback_message_id = $callback_query['message']['message_id'] ?? null;
    
    // Answer callback query
    bot('answerCallbackQuery', [
        'callback_query_id' => $callback_query['id']
    ]);
    
    // Route callback queries
    switch ($callback_data) {
        case 'upload':
            if (isAdmin($user_id)) {
                sendMessage($chat_id, "📤 لطفاً فایل را آپلود کنید.", getInlineKeyboard('main'));
            } else {
                sendMessage($chat_id, "❌ فقط ادمین‌ها می‌توانند آپلود کنند.");
            }
            break;
            
        case 'admins':
            if (isAdmin($user_id)) {
                handleListAdmins($chat_id);
                sendMessage($chat_id, "👥 مدیریت ادمین‌ها:", getInlineKeyboard('admins'));
            }
            break;
            
        case 'add_admin':
            if (isMainAdmin($user_id)) {
                sendMessage($chat_id, "➕ لطفاً کاربر را forward کنید یا شناسه کاربر را ارسال کنید.");
            }
            break;
            
        case 'remove_admin':
            if (isMainAdmin($user_id)) {
                sendMessage($chat_id, "➖ لطفاً کاربر را forward کنید یا شناسه کاربر را ارسال کنید.");
            }
            break;
            
        case 'list_admins':
            if (isAdmin($user_id)) {
                handleListAdmins($chat_id);
            }
            break;
            
        case 'stats':
            if (isAdmin($user_id)) {
                displayAnalytics($chat_id);
            }
            break;
            
        case 'channel_settings':
            if (isAdmin($user_id)) {
                handleListChannels($chat_id);
            }
            break;
            
        case 'back_main':
            sendMessage($chat_id, "🏠 منوی اصلی:", getInlineKeyboard('main'));
            break;
            
        case 'download_file':
            // User wants to download a file - show file list or handle download
            // For now, we'll need to implement file browsing
            sendMessage($chat_id, "📥 برای دانلود فایل، لطفاً شناسه فایل را ارسال کنید یا از منوی فایل‌ها استفاده کنید.");
            break;
            
        case 'my_points':
            displayUserPoints($chat_id, $user_id);
            break;
            
        case 'my_referral':
            displayReferralInfo($chat_id, $user_id);
            break;
            
        case 'delete_time':
            if (isAdmin($user_id)) {
                sendMessage($chat_id, "⏰ تنظیم تایم حذف خودکار\n\nلطفاً به پیام فایلی که می‌خواهید timer برای آن تنظیم کنید reply کنید و سپس یکی از دستورات زیر را ارسال کنید:\n\n/autodelete_30s - 30 ثانیه\n/autodelete_1m - 1 دقیقه\n/autodelete_5m - 5 دقیقه\n/autodelete_10m - 10 دقیقه\n/autodelete_30m - 30 دقیقه\n/autodelete_1h - 1 ساعت\n/autodelete_6h - 6 ساعت\n/autodelete_24h - 24 ساعت\n\nیا برای تنظیم زمان دلخواه:\n/autodelete <ثانیه>\nمثال: /autodelete 120 (برای 2 دقیقه)\n\n/autodelete_off - غیرفعال کردن");
            }
            break;
            
        default:
            // Check if callback is for downloading a specific file (format: download_<file_id>)
            if (strpos($callback_data, 'download_') === 0) {
                $file_id = (int)str_replace('download_', '', $callback_data);
                
                // Check forced join channels first
                require_once "handlers/channel-handler.php";
                $file = getFileById($file_id);
                
                if ($file !== false && !empty($file['forced_join_channels'])) {
                    $required_channels = json_decode($file['forced_join_channels'], true);
                    if ($required_channels) {
                        $membership = checkChannelMembership($user_id, $required_channels);
                        
                        if (!$membership['is_member']) {
                            $forced_text = getForcedJoinText();
                            $message = "{$forced_text}\n\n";
                            
                            // Get channel info
                            $placeholders = implode(',', array_fill(0, count($membership['missing_channels']), '?'));
                            $channels = dbQuery(
                                "SELECT * FROM channels WHERE channel_id IN ({$placeholders})",
                                $membership['missing_channels']
                            );
                            
                            if ($channels !== false) {
                                foreach ($channels as $channel) {
                                    $link = $channel['channel_link'] ?: ($channel['channel_username'] ? 'https://t.me/' . $channel['channel_username'] : '');
                                    $message .= "📢 {$channel['channel_title']}\n";
                                    if ($link) {
                                        $message .= "🔗 {$link}\n\n";
                                    }
                                }
                            }
                            
                            sendMessage($chat_id, $message);
                            exit;
                        }
                    }
                }
                
                // Handle download
                $result = handleFileDownload($user_id, $file_id, $chat_id);
                
                if ($result['success']) {
                    sendMessage($chat_id, $result['message']);
                } else {
                    sendMessage($chat_id, $result['message']);
                }
            }
            break;
    }
    
    exit;
}

// Handle private chat messages
if ($chat_type == "private") {
    // Check if user is blocked
    if (isUserBlocked($user_id)) {
        sendMessage($chat_id, "❌ شما بلاک شده‌اید و نمی‌توانید از ربات استفاده کنید.");
        exit;
    }
    
    // Handle commands
    if ($text && strpos($text, '/') === 0) {
        $command = explode(' ', $text)[0];
        $command = strtolower($command);
        
        switch ($command) {
            case '/start':
                $start_param = getStartParameter($text);
                
                if ($start_param) {
                    // Check if it's a file code
                    require_once "handlers/upload-handler.php";
                    $file = getFileByCode($start_param);
                    
                    if ($file !== false) {
                        // User wants to download a file
                        $file_id = (int)$file['id'];
                        
                        // Check forced join channels first
                        require_once "handlers/channel-handler.php";
                        if (!empty($file['forced_join_channels'])) {
                            $required_channels = json_decode($file['forced_join_channels'], true);
                            if ($required_channels) {
                                $membership = checkChannelMembership($user_id, $required_channels);
                                
                                if (!$membership['is_member']) {
                                    $forced_text = getForcedJoinText();
                                    $message = "{$forced_text}\n\n";
                                    
                                    // Get channel info
                                    $placeholders = implode(',', array_fill(0, count($membership['missing_channels']), '?'));
                                    $channels = dbQuery(
                                        "SELECT * FROM channels WHERE channel_id IN ({$placeholders})",
                                        $membership['missing_channels']
                                    );
                                    
                                    if ($channels !== false) {
                                        foreach ($channels as $channel) {
                                            $link = $channel['channel_link'] ?: ($channel['channel_username'] ? 'https://t.me/' . $channel['channel_username'] : '');
                                            $message .= "📢 {$channel['channel_title']}\n";
                                            if ($link) {
                                                $message .= "🔗 {$link}\n\n";
                                            }
                                        }
                                    }
                                    
                                    sendMessage($chat_id, $message);
                                    exit;
                                }
                            }
                        }
                        
                        // Handle download
                        $result = handleFileDownload($user_id, $file_id, $chat_id);
                        
                        if ($result['success']) {
                            // File already sent, just show success message
                            sendMessage($chat_id, $result['message']);
                        } else {
                            sendMessage($chat_id, $result['message']);
                        }
                        exit;
                    }
                    
                    // Check if it's a referral code
                    $referral_result = handleReferralUsage($user_id, $start_param);
                    
                    if ($referral_result['success']) {
                        $points = $referral_result['points_given'];
                        sendMessage($chat_id, "✅ خوش آمدید!\n🎁 شما و معرف شما امتیاز دریافت کردید!");
                    }
                }
                
                // Show welcome message
                if (isAdmin($user_id)) {
                    sendMessage($chat_id, "👋 سلام! به پنل ادمین خوش آمدید.", getInlineKeyboard('main'));
                } else {
                    sendMessage($chat_id, "👋 سلام! به ربات آپلودر فایل خوش آمدید.\n\n💎 امتیاز شما: " . getUserPoints($user_id));
                }
                break;
                
            case '/points':
            case '/امتیاز':
                displayUserPoints($chat_id, $user_id);
                break;
                
            case '/referral':
            case '/معرف':
                displayReferralInfo($chat_id, $user_id);
                break;
                
            case '/addadmin':
                if (isMainAdmin($user_id)) {
                    handleAddAdmin($message);
                } else {
                    sendMessage($chat_id, "❌ فقط ادمین اصلی می‌تواند ادمین اضافه کند.");
                }
                break;
                
            case '/removeadmin':
                if (isMainAdmin($user_id)) {
                    handleRemoveAdmin($message);
                } else {
                    sendMessage($chat_id, "❌ فقط ادمین اصلی می‌تواند ادمین حذف کند.");
                }
                break;
                
            case '/listadmins':
                if (isAdmin($user_id)) {
                    handleListAdmins($chat_id);
                }
                break;
                
            case '/addchannel':
                if (isAdmin($user_id)) {
                    handleAddChannel($message);
                }
                break;
                
            case '/removechannel':
                if (isAdmin($user_id)) {
                    handleRemoveChannel($message);
                }
                break;
                
            case '/listchannels':
                if (isAdmin($user_id)) {
                    handleListChannels($chat_id);
                }
                break;
                
            case '/stats':
            case '/آمار':
                if (isAdmin($user_id)) {
                    displayAnalytics($chat_id);
                }
                break;
                
            case '/searchuser':
                if (isAdmin($user_id)) {
                    handleSearchUser($message);
                }
                break;
                
            case '/settings':
            case '/تنظیمات':
                if (isAdmin($user_id)) {
                    displaySettings($chat_id);
                }
                break;
                
            case '/broadcast':
                if (isAdmin($user_id)) {
                    handleBroadcast($message, 'normal');
                }
                break;
                
            case '/broadcastforward':
                if (isAdmin($user_id)) {
                    handleBroadcast($message, 'forward');
                }
                break;
                
            case '/autodelete_30s':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 30);
                }
                break;
                
            case '/autodelete_1m':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 60);
                }
                break;
                
            case '/autodelete_5m':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 300);
                }
                break;
                
            case '/autodelete_10m':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 600);
                }
                break;
                
            case '/autodelete_30m':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 1800);
                }
                break;
                
            case '/autodelete_1h':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 3600);
                }
                break;
                
            case '/autodelete_6h':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 21600);
                }
                break;
                
            case '/autodelete_24h':
                if (isAdmin($user_id)) {
                    handleSetAutoDelete($message, 86400);
                }
                break;
                
            case '/autodelete':
                if (isAdmin($user_id)) {
                    // Extract seconds from command (format: /autodelete <seconds>)
                    $parts = explode(' ', $text, 2);
                    if (isset($parts[1]) && is_numeric($parts[1])) {
                        $seconds = (int)$parts[1];
                        if ($seconds > 0) {
                            handleSetAutoDelete($message, $seconds);
                        } else {
                            sendMessage($chat_id, "❌ لطفاً عددی بزرگ‌تر از صفر وارد کنید.");
                        }
                    } else {
                        sendMessage($chat_id, "❌ لطفاً تعداد ثانیه را وارد کنید.\nمثال: /autodelete 120");
                    }
                }
                break;
                
            case '/autodelete_off':
                if (isAdmin($user_id)) {
                    // Remove auto-delete
                    if (!isset($message['reply_to_message'])) {
                        sendMessage($chat_id, "❌ لطفاً به پیام فایلی که می‌خواهید timer را غیرفعال کنید reply کنید.");
                        break;
                    }
                    
                    $replied_message = $message['reply_to_message'];
                    require_once "handlers/upload-handler.php";
                    $file_info = extractFileInfo($replied_message);
                    
                    if ($file_info === false) {
                        sendMessage($chat_id, "❌ خطا در دریافت اطلاعات فایل.");
                        break;
                    }
                    
                    $file = dbQueryOne(
                        "SELECT id FROM files WHERE file_id = ? AND is_active = 1 ORDER BY created_at DESC LIMIT 1",
                        [$file_info['file_id']]
                    );
                    
                    if ($file === false) {
                        sendMessage($chat_id, "❌ فایل در دیتابیس یافت نشد.");
                        break;
                    }
                    
                    if (removeFileAutoDelete((int)$file['id'])) {
                        sendMessage($chat_id, "✅ Timer حذف خودکار غیرفعال شد!");
                    } else {
                        sendMessage($chat_id, "❌ خطا در غیرفعال کردن timer.");
                    }
                }
                break;
                
            case '/download':
            case '/دانلود':
                // Download file by ID (format: /download <file_id>)
                $parts = explode(' ', $text, 2);
                if (isset($parts[1]) && is_numeric($parts[1])) {
                    $file_id = (int)$parts[1];
                    
                    // Check forced join channels first
                    require_once "handlers/channel-handler.php";
                    $file = getFileById($file_id);
                    
                    if ($file !== false && !empty($file['forced_join_channels'])) {
                        $required_channels = json_decode($file['forced_join_channels'], true);
                        if ($required_channels) {
                            $membership = checkChannelMembership($user_id, $required_channels);
                            
                            if (!$membership['is_member']) {
                                $forced_text = getForcedJoinText();
                                $message = "{$forced_text}\n\n";
                                
                                // Get channel info
                                $placeholders = implode(',', array_fill(0, count($membership['missing_channels']), '?'));
                                $channels = dbQuery(
                                    "SELECT * FROM channels WHERE channel_id IN ({$placeholders})",
                                    $membership['missing_channels']
                                );
                                
                                if ($channels !== false) {
                                    foreach ($channels as $channel) {
                                        $link = $channel['channel_link'] ?: ($channel['channel_username'] ? 'https://t.me/' . $channel['channel_username'] : '');
                                        $message .= "📢 {$channel['channel_title']}\n";
                                        if ($link) {
                                            $message .= "🔗 {$link}\n\n";
                                        }
                                    }
                                }
                                
                                sendMessage($chat_id, $message);
                                break;
                            }
                        }
                    }
                    
                    // Handle download
                    $result = handleFileDownload($user_id, $file_id, $chat_id);
                    
                    if ($result['success']) {
                        sendMessage($chat_id, $result['message']);
                    } else {
                        sendMessage($chat_id, $result['message']);
                    }
                } else {
                    sendMessage($chat_id, "❌ لطفاً شناسه فایل را ارسال کنید.\nمثال: /download 1");
                }
                break;
                
            default:
                // Unknown command
                break;
        }
        
        exit;
    }
    
    // Handle file uploads (admin only)
    if (isAdmin($user_id)) {
        // Check if message contains a file
        if (isset($message['photo']) || isset($message['video']) || isset($message['document']) ||
            isset($message['audio']) || isset($message['voice']) || isset($message['video_note']) ||
            isset($message['sticker']) || isset($message['animation'])) {
            
            // Check if it's part of an album
            if (isset($message['media_group_id'])) {
                handleAlbumUpload($message);
            } else {
                handleFileUpload($message);
            }
            
            exit;
        }
    }
    
    // Handle regular messages
    // For now, just echo back or show menu
    if ($text && !isAdmin($user_id)) {
        sendMessage($chat_id, "👋 برای استفاده از ربات، از دستورات استفاده کنید.\n\n💎 امتیاز شما: " . getUserPoints($user_id));
    }
}
